-- Full portal DB with social login
CREATE DATABASE IF NOT EXISTS hotspot_portal;
USE hotspot_portal;

CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mobile VARCHAR(20) DEFAULT NULL,
    email VARCHAR(255) DEFAULT NULL,
    mac VARCHAR(20) NOT NULL,
    otp VARCHAR(6) DEFAULT NULL,
    is_social TINYINT(1) DEFAULT 0,
    social_provider VARCHAR(50) DEFAULT NULL,
    social_id VARCHAR(255) DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS social_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    provider VARCHAR(50) NOT NULL,
    social_id VARCHAR(255) NOT NULL,
    email VARCHAR(255) DEFAULT NULL,
    name VARCHAR(255) DEFAULT NULL,
    profile_pic VARCHAR(255) DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS login_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT DEFAULT NULL,
    mac VARCHAR(20) DEFAULT NULL,
    ip VARCHAR(45) DEFAULT NULL,
    login_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    provider VARCHAR(50) DEFAULT NULL,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
);

CREATE TABLE IF NOT EXISTS quota (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    bytes_used BIGINT DEFAULT 0,
    time_used INT DEFAULT 0,
    quota_bytes BIGINT DEFAULT 536870912,
    quota_time INT DEFAULT 60,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);
